
CREATE OR REPLACE FUNCTION TSystem.views__wawipos__layouts__drop() RETURNS void
  AS $$
  BEGIN

    DROP FUNCTION IF EXISTS TWawi.extend_layout__pos(TWawi.view__pos__type);
    DROP FUNCTION IF EXISTS TWawi.extend_layout__pos(auftg, auftgmatinfo);
    DROP FUNCTION IF EXISTS TWawi.extend_layout__pos(ldsdok);

    DROP FUNCTION IF EXISTS TWawi.extend_layout__pos__beleg;
    DROP FUNCTION IF EXISTS TWawi.extend_layout__beleg;

    PERFORM TWawi.view__types__normalize__drop();

  END $$ LANGUAGE plpgsql;




CREATE OR REPLACE FUNCTION TSystem.views__wawipos__layouts__create() RETURNS void
  AS $f0$
  BEGIN

    EXECUTE $f1$

      -- Layouts
        -- Rechnungen
          DROP FUNCTION IF EXISTS TWawi.extend_layout__pos(TWawi.view__pos__type);
          CREATE OR REPLACE FUNCTION TWawi.extend_layout__pos(IN _rechx TWawi.view__pos__type)
            RETURNS TABLE (
              p_wert_tot_netto_gwaer_cimformat    varchar(200),
              p_wert_tot_netto_cimformat          varchar(200),
              p_wert_tot_netto_cimred             boolean,
              p_wert_tot_brutto_cimred            boolean,
              p_wert_tot_netto_gwaer_cimred       boolean,
              p_wert_tot_brutto_gwaer_cimred      boolean,
              p_preis_sumsubpos_cimred            boolean
              )
              AS $$
                  WITH data  AS (SELECT 'bold,CimUnterline'::varchar(200)     AS format_bold, 
                                        'italic,bold'::varchar(200)           AS format_italic, 
                                        'cimyellow'::varchar(200)             AS format_yellow,
                                        'CimFontGray,italic'::varchar(200)    AS format_gray
                                )
                  SELECT 
                         format_bold                                          AS p_wert_tot_netto_gwaer_cimformat,
                         format_italic                                        AS p_wert_tot_netto_cimformat,
                        -- Preis enthält Unterposition (somit NICHT werthaltig)
                         _rechx.p_preis_sumsubpos IS true                     AS p_wert_tot_netto_cimred,
                         _rechx.p_preis_sumsubpos IS true                     AS p_wert_tot_brutto_cimred,
                         _rechx.p_preis_sumsubpos IS true                     AS p_wert_tot_netto_gwaer_cimred,
                         _rechx.p_preis_sumsubpos IS true                     AS p_wert_tot_brutto_gwaer_cimred,
                         _rechx.p_preis_sumsubpos IS true                     AS p_preis_sumsubpos_cimred
                  FROM data
            $$ LANGUAGE sql STABLE PARALLEL SAFE;

          -- Zur Position den Beleg anjoinen => Belegfelder grau!
          DROP FUNCTION IF EXISTS TWawi.extend_layout__rechnungx__pos__beleg(TWawi.view__beleg__type);
          CREATE OR REPLACE FUNCTION TWawi.extend_layout__pos__beleg(IN _belegx TWawi.view__beleg__type)
            RETURNS TABLE (
              d_dokunr_cimformat                  varchar(64),
              d_code_cimformat                    varchar(5),
              d_wert_tot_netto_cimformat          varchar(200),
              d_wert_tot_brutto_cimformat         varchar(200),
              d_wert_tot_netto_gwaer_cimformat    varchar(200),
              d_wert_tot_brutto_gwaer_cimformat   varchar(200)
              )
              AS $$                  
                  WITH data  AS (SELECT 'bold,CimUnterline'::varchar(200)     AS format_bold, 
                                        'italic,bold'::varchar(200)           AS format_italic, 
                                        'cimyellow'::varchar(200)             AS format_yellow,
                                        'CimFontGray,italic'::varchar(200)    AS format_gray
                                )
                  SELECT format_bold                                                AS d_dokunr_cimformat,
                         IFTHEN(_belegx.d_code = 'G', format_yellow, null::varchar) AS d_code_cimformat,
                         format_gray                                                AS d_wert_tot_netto_cimformat,
                         format_gray                                                AS d_wert_tot_brutto_cimformat,
                         format_gray                                                AS d_wert_tot_netto_gwaer_cimformat,
                         format_gray                                                AS d_wert_tot_brutto_gwaer_cimformat
                  FROM data
            $$ LANGUAGE sql STABLE PARALLEL SAFE;


          -- Belegkopf führend, dann diese Felder hervorheben
          DROP FUNCTION IF EXISTS TWawi.extend_layout__beleg(TWawi.view__beleg__type);
          CREATE OR REPLACE FUNCTION TWawi.extend_layout__beleg(IN _belegx TWawi.view__beleg__type)
            RETURNS TABLE (
              d_dokunr_cimformat                  varchar(64),
              d_code_cimformat                    varchar(5),
              d_wert_tot_netto_cimformat          varchar(200),
              d_wert_tot_brutto_cimformat         varchar(200),
              d_wert_tot_netto_gwaer_cimformat    varchar(200),
              d_wert_tot_brutto_gwaer_cimformat   varchar(200),
              d_zahlung_done_CimRed               boolean
              )
              AS $$
                  WITH data  AS (SELECT 'bold,CimUnterline'::varchar(200)     AS format_bold, 
                                        'italic,bold'::varchar(200)           AS format_italic, 
                                        'cimyellow'::varchar(200)             AS format_yellow,
                                        'CimFontGray,italic'::varchar(200)    AS format_gray
                                )
                  SELECT format_bold                                                AS d_dokunr_cimformat,
                         IFTHEN(_belegx.d_code = 'G', format_yellow, null::varchar) AS d_code_cimformat,
                         format_italic                                              AS d_wert_tot_netto_cimformat,
                         format_italic                                              AS d_wert_tot_brutto_cimformat,
                         format_bold                                                AS d_wert_tot_netto_gwaer_cimformat,
                         format_bold                                                AS d_wert_tot_brutto_gwaer_cimformat,

                         NOT _belegx.d_zahlung_done AND _belegx.d_datum_erfasst + _belegx.d_zahlung_tage < current_date AS d_zahlung_done_CimRed

                  FROM data
            $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
        --

        -- WarenWirtschaft

          DROP FUNCTION IF EXISTS TWawi.extend_layout__pos(auftg, auftgmatinfo);
          CREATE OR REPLACE FUNCTION TWawi.extend_layout__pos(IN _auftg auftg, IN _auftgmatinfo auftgmatinfo = null)
            RETURNS TABLE (
              ag_done_cimgreen                    boolean,
              ag_done_cimred                      boolean,
              ag_storno_cimred                    boolean,
              ag_stat_cimred                      boolean,

              ag_nbedarf_cimred                   boolean,
              agmi_beistell_cimred                boolean,
              ag_stk_cimred                       boolean,
              ag_stk_uf1_cimred                   boolean
              )
              AS $$
                  WITH _data AS (SELECT _auftg.*, _auftgmatinfo.*)
                  SELECT  ag_done                     IS true         AS ag_done_cimgreen,
                          ag_storno                   IS true         AS ag_done_cimred,
                          ag_storno                   IS true         AS ag_storno_cimred,
                          
                          ag_nbedarf                  IS true         AS ag_nbedarf_cimred,
                          agmi_beistell               IS true         AS agmi_beistell_cimred,
                          ag_nbedarf                  IS true
                       OR agmi_beistell               IS true         AS ag_stk_cimred,                          
                          ag_nbedarf                  IS true
                       OR agmi_beistell               IS true         AS ag_stk_uf1_cimred,                          

                          TSystem.ENUM_GetValue(ag_stat, 'UE')        AS ag_stat_cimred
                  FROM _data

              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.extend_layout__pos(ldsdok);
          CREATE OR REPLACE FUNCTION TWawi.extend_layout__pos(IN _ldsdok ldsdok)
            RETURNS TABLE (
              ld_done_cimgreen                  boolean,
              ld_done_cimred                    boolean,
              ld_storno_cimred                  boolean,

              ld_nbedarf_cimred                 boolean,
              ld_stk_cimred                     boolean,
              ld_stk_uf1_cimred                 boolean
              )
              AS $$
                WITH _data AS (SELECT _ldsdok.*)
                SELECT  ld_done                       IS true    AS ld_done_cimgreen,                        
                        ld_storno                     IS true    AS ld_done_cimred,
                        ld_storno                     IS true    AS ld_storno_cimred,

                        ld_nbedarf                    IS true    AS ld_nbedarf_cimred,
                        ld_nbedarf                    IS true    AS ld_stk_cimred,
                        ld_nbedarf                    IS true    AS ld_stk_uf1_cimred

                FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
        --
      -- Layouts

      -- Default Columns WaWi
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__basics(auftg);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__basics(IN _auftg auftg)
            RETURNS TABLE(
              dbrid         varchar(32),
              ag_id         integer,

              ag_astat      varchar(1),
              ag_nr         varchar(30),
              ag_pos        integer,

              ag_lkn        varchar(21),
              ag_lkn__name  varchar(100),

              ag_done       boolean,
              ag_storno     boolean,

              ag_bstat      varchar(2),
              ag_bstat1     varchar(2),
              ag_bstat2     varchar(2),
              ag_stat       varchar(40),

              auftg__stat__w boolean

              )
              AS $$
                  WITH _data AS (SELECT _auftg.*)
                  SELECT dbrid,
                         ag_id,

                         ag_astat,
                         ag_nr,
                         ag_pos,

                         ag_lkn,
                         adressename(ag_lkn),

                         ag_done,
                         ag_storno,

                         ag_bstat,
                         ag_bstat1,
                         ag_bstat2,                         
                         ag_stat,

                         twawi.auftg__stat__x(_auftg, 'W') AS auftg__stat__w
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__art(auftg, art);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__art(IN _auftg auftg, IN _art art = null)
            RETURNS TABLE(
              ak_ac         varchar(9),
              ag_aknr       varchar(75),
              ag_aknr_idx   varchar(10),
              ak_bez        varchar(250),
              ak_znr        varchar(75),
              ak_such       varchar(75)
              )
              AS $$
                  WITH _data AS (SELECT _auftg.*, _art.*)
                  SELECT ak_ac,
                         ag_aknr,
                         ag_aknr_idx,
                         coalesce(ag_akbz, ak_bez) AS ak_bez,
                         ak_znr,
                         ak_such
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__mengen(auftg, art);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__mengen(IN _auftg auftg)
              RETURNS TABLE(
              ag_stk        numeric(12,4),      
              ag_stkl_uf    numeric(12,4),
              p_mengeo      numeric(12,4),
              ag_stkf_uf    numeric(12,4),
              
              lang_artmgc_id_iso varchar(30)
              )
              AS $$
                  WITH _data AS (SELECT _auftg.*)
                  SELECT 
                         ag_stk,
                                  tartikel.me__menge_uf1__in__menge(ag_mcv, ag_stkl) AS ag_stkl_uf,
                         ag_stk - tartikel.me__menge_uf1__in__menge(ag_mcv, ag_stkl) AS p_mengeo,
                                  tartikel.me__menge_uf1__in__menge(ag_mcv, ag_stkf) AS ag_stkf_uf,

                         lang_artmgc_id_iso(ag_mcv)
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__mengen_uf1(auftg, art);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__mengen_uf1(IN _auftg auftg)
              RETURNS TABLE(
              ag_stk_uf1    numeric(12,4),      
              ag_stkl_uf1   numeric(12,4),
              p_mengeo_gme  numeric(12,4),
              ag_stkf_uf1   numeric(12,4),
              
              standardmgc_iso varchar(30)
              )
              AS $$
                  WITH _data AS (SELECT _auftg.*)
                  SELECT 
                         ag_stk_uf1,
                         ag_stkl,
                         ag_stk_uf1 - ag_stkl AS p_mengeo_gme,
                         ag_stkf,

                         standardmgc_iso(ag_aknr)
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          /*
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__art__preise__uf1(auftg, art);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__art__preise__uf1(IN _auftg auftg)
            RETURNS TABLE(        
              ag_stk_uf1    numeric(12,4),
              ag_stkl       numeric(12,4),
              p_mengeo_gme  numeric(12,4),
              ag_stkf       numeric(12,4),

              ag_preis_uf1_basis_w numeric(12,4),

              standardmgc_iso varchar(30),
        
              ak_tot        numeric(12,4)
              )
              AS $$
                  WITH _data AS (SELECT _auftg.*)
                  SELECT 
                         ag_stk_uf1,
                         ag_stkl,
                         ag_stk_uf1 - ag_stkl AS p_mengeo_gme,
                         ag_stkf,

                         tartikel.me__preis__in__preis_uf1(ag_mcv, ag_preis),

                         standardmgc_iso(ag_aknr)
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          */
          --  
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__werte(auftg);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__werte(IN _auftg auftg)
            RETURNS TABLE(
              ag_preis          numeric(12,4),
              ag_arab           numeric(12,4),
              ag_preis_uf1      numeric(12,4),
              ag_netto          numeric(12,4),
              ag_netto_basis_w  numeric(12,4)
              )
              AS $$
                  WITH _data AS (SELECT _auftg.*)
                  SELECT 
                         ag_preis,
                         ag_arab,
                         tartikel.me__preis__in__preis_uf1(ag_mcv, ag_vkp /*bereits mit Preiseinheit verrechnet*/) AS ag_preis_uf1,
                         ag_netto,
                         ag_netto_basis_w
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__dates(auftg);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__dates(IN _auftg auftg)
            RETURNS TABLE(
              ag_datum        date,
              ag_kdatum       date,
              ag_ldatum       date,
              ag_aldatum      date,              
              ag_termv        date,
              ag_ldatumtext   varchar(150)
              )
              AS $$
                  WITH _data AS (SELECT _auftg.*)
                  SELECT
                      ag_datum,
                      ag_kdatum,
                      ag_ldatum,
                      ag_aldatum,
                      ag_termv,
                      ag_ldatumtext
                  FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__dates__extend__lieferung(auftg);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__dates__extend__lieferung(IN _auftg auftg)
              RETURNS TABLE 
                  (
                  ag_ldatum_coalesce                  date,
                  ag_ldatum_coalesce_cimred           boolean,
                  ag_ldatum_coalesce_cimyellow        boolean,
    
                  ldatumfr                            date,
                  ldatumfr_cimgreen                   boolean,
                  ldatums                             date,
                  ldatums_cimyellow                   boolean,              
                  ldatums_cimred                      boolean,
    
                  ag_aldatum_cimred                   boolean,
                  ag_aldatum_cimyellow                boolean,
                  ag_aldatum_now                      boolean,
                  ag_aldatum_now_cimgreen             boolean,
                  ag_aldatum_now_cimyellow            boolean,
                  ag_aldatum_now_cimred               boolean,
    
                  ag_aldatum_kw                       integer, 
                  ag_aldatum_kw_cimred                boolean,
                  ag_aldatum_kw_cimgreen              boolean,
                  ag_aldatum_kw_cimyellow             boolean,
    
                  ag_aldatum_kw__current              boolean,
    
                  art__auftg__lieferbar_menge         numeric,
                  auslieferbar                        boolean,
                  auslieferbar_cimyellow              boolean,
                  auslieferbar_teil                   boolean
                  )
              AS $$
                  WITH _data AS (SELECT _auftg.*, TSystem.Settings__GetBool('auftg_alterm_inkl_tol') AS _auftg_alterm_inkl_tol)
                  SELECT  coalesce(ag_ldatum, ag_kdatum)                                                        AS ag_ldatum_coalesce,
                          coalesce(ag_ldatum, ag_kdatum) < current_date                                         AS ag_ldatum_coalesce_cimred,
                          coalesce(ag_ldatum, ag_kdatum) = current_date                                         AS ag_ldatum_coalesce_cimyellow,

                          -- LATERAL JOIN
                          ldatumfr,
                          ldatumfr <= current_date                                                              AS ldatumfr_cimgreen,
                          ldatums,
                          ldatums = current_date                                                                AS ldatums_cimyellow,
                          ldatums < current_date                                                                AS ldatums_cimred,

                          --ag_aldatum,
                          ag_aldatum  < current_date                                                            AS ag_aldatum_cimred,
                          ag_aldatum  = current_date                                                            AS ag_aldatum_cimyellow,
                          ag_aldatum <= current_date                                                            AS ag_aldatum_now,
                          ag_aldatum <= current_date AND _lieferbar_menge >= ag_stk_uf1 - ag_stkl               AS ag_aldatum_now_cimgreen,
                          ag_aldatum <= current_date AND _lieferbar_menge <  ag_stk_uf1 - ag_stkl               AS ag_aldatum_now_cimyellow,
                          ag_aldatum <= current_date AND _lieferbar_menge <= 0                                  AS ag_aldatum_now_cimred,

                          termweek(date_larger(ag_aldatum, current_date))                                       AS ag_aldatum_kw,
                          termweek(ag_aldatum) <  termweek(current_date)                                        AS ag_aldatum_kw_cimred,
                          termweek(ag_aldatum)  = termweek(current_date) AND ldatumfr <= current_date           AS ag_aldatum_kw_cimgreen,
                          termweek(ag_aldatum)  = termweek(current_date) AND ldatumfr >  current_date           AS ag_aldatum_kw_cimyellow,
                        
                          termweek(ag_aldatum) <= termweek(current_date)                                        AS ag_aldatum_kw__current,
                                                
                          _lieferbar_menge                                                                      AS art__auftg__lieferbar_menge,
                          _lieferbar_menge >= ag_stk_uf1 - ag_stkl                                              AS auslieferbar,
                          _lieferbar_menge > 0 AND _lieferbar_menge < ag_stk_uf1 - ag_stkl                      AS auslieferbar_cimyellow,
                          _lieferbar_menge > 0 AND _lieferbar_menge < ag_stk_uf1 - ag_stkl                      AS auslieferbar_teil
                  FROM _data
                  LEFT JOIN adk  ON ad_krz = ag_lkn
                  LEFT JOIN adk1 ON a1_krz = ad_krz
                  LEFT JOIN LATERAL cast(coalesce(IFTHEN(_auftg_alterm_inkl_tol, ag_aldatum, null), timediff_addsubstdays(coalesce(IFTHEN(_auftg_alterm_inkl_tol, null, ag_aldatum), ag_ldatum, ag_kdatum), -1 * a1_tolfrueh, true) ) AS date) AS ldatumfr ON true
                  LEFT JOIN LATERAL cast(timediff_addsubstdays(coalesce(ag_aldatum, ag_ldatum, ag_kdatum), a1_tolspaet, true) AS date) AS ldatums  ON true                  
                  , LATERAL tartikel.art__auftg__lieferbar_menge(ag_id) AS _lieferbar_menge

              $$ LANGUAGE sql STABLE PARALLEL SAFE;

          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__stat(auftg);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__stat(IN _auftg auftg)
            RETURNS TABLE(
              ag_sperr        boolean,
              ag_dokunr       integer,
              ag_done         boolean,
              ag_storno       boolean,
              ag_stat         varchar(200),
              ag_parentabk    integer,
              ag_an_nr        varchar(50)
              )
              AS $$
                  WITH _data AS (SELECT _auftg.*)
                  SELECT
                      ag_sperr,
                      ag_dokunr,
                      ag_done,
                      ag_storno,
                      ag_stat,
                      ag_parentabk,
                      ag_an_nr
                  FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --


          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__basics(ldsdok);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__basics(IN _ldsdok ldsdok)
            RETURNS TABLE(
              dbrid              varchar(32),
              ld_id              integer,
              ld_code            varchar(1),
              ld_auftg           varchar(30),
              ld_pos             integer,
              ld_kn              varchar(21),
              ld_kn__name        varchar(100)
              )
              AS $$
                  WITH _data AS (SELECT _ldsdok.*)
                  SELECT dbrid,
                         ld_id,
                         ld_code,
                         ld_auftg,
                         ld_pos,
                         ld_kn,
                         adressename(ld_kn)
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__art__mengen(ldsdok, art);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__art__mengen(IN _ldsdok ldsdok, IN _art art = null)
            RETURNS TABLE(
              ld_aknr       varchar(75),
              ld_aknr_idx   varchar(10),
              ak_bez        varchar(250),
        
              ld_stk        numeric(12,4),      
              ld_stkl_uf    numeric(12,4),
              p_mengeo      numeric(12,4),
              ld_stkf_uf    numeric(12,4),
              
              lang_artmgc_id_iso varchar(30),

              ld_nbedarf    boolean
              )
              AS $$
                  WITH _data AS (SELECT _ldsdok.*, _art.*)
                  SELECT 
                         ld_aknr,
                         ld_aknr_idx,
                         coalesce(ld_akbz, ak_bez) AS ak_bez,

                         ld_stk,
                                  tartikel.me__menge_uf1__in__menge(ld_mce, ld_stkl) AS ld_stkl_uf,
                         ld_stk - tartikel.me__menge_uf1__in__menge(ld_mce, ld_stkl) AS p_mengeo,
                                  tartikel.me__menge_uf1__in__menge(ld_mce, ld_stkf) AS ld_stkf_uf,

                         lang_artmgc_id_iso(ld_mce),

                         ld_nbedarf
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__art__mengen_uf1(ldsdok, art);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__art__mengen_preise__uf1(IN _ldsdok ldsdok, IN _art art = null)
            RETURNS TABLE(        
              ld_stk_uf1    numeric(12,4),
              ld_stkl       numeric(12,4),
              p_mengeo_gme  numeric(12,4),
              ld_stkf       numeric(12,4),

              ld_preis_uf1_basis_w numeric(12,4),

              standardmgc_iso varchar(30),
        
              ak_tot        numeric(12,4)
              )
              AS $$
                  WITH _data AS (SELECT _ldsdok.*, _art.*)
                  SELECT 
                         ld_stk_uf1,
                         ld_stkl,
                         ld_stk_uf1 - ld_stkl AS p_mengeo_gme,                         
                         ld_stkf,

                         tartikel.me__preis__in__preis_uf1(ld_mce, ld_preis),                         

                         standardmgc_iso(ld_aknr),          
              
                         ak_tot
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__werte(ldsdok);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__werte(IN _ldsdok ldsdok, IN _art art = null)
            RETURNS TABLE(
              ld_preis          numeric(12,4),
              ld_arab           numeric(12,4),
              ld_preis_uf1      numeric(12,4),
              ld_netto          numeric(12,4),
              ld_netto_basis_w  numeric(12,4)
              )
              AS $$
                  WITH _data AS (SELECT _ldsdok.*)
                  SELECT 
                         ld_preis,
                         ld_arab,
                         tartikel.me__preis__in__preis_uf1(ld_mce, ld_ep /*bereits mit Preiseinheit verrechnet*/) AS ld_preis_uf1,
                         ld_netto,
                         ld_netto_basis_w
                    FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__dates(ldsdok);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__dates(IN _ldsdok ldsdok)
            RETURNS TABLE(
              ld_datum        date,
              ld_term         date,
              ld_terml        date,
              ld_termv        date
              )
              AS $$
                  WITH _data AS (SELECT _ldsdok.*)
                  SELECT
                      ld_datum,
                      ld_term,
                      ld_terml,
                      ld_termv
                  FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
          DROP FUNCTION IF EXISTS TWawi.default_columns__pos__stat(ldsdok);
          CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__stat(IN _ldsdok ldsdok)
            RETURNS TABLE(
              ld_sperr        boolean,
              ld_dokunr       integer,
              ld_done         boolean,
              ld_storno       boolean,
              ld_stat         varchar(200),
              ld_abk          integer,
              ld_an_nr        varchar(50)
              )
              AS $$
                  WITH _data AS (SELECT _ldsdok.*)
                  SELECT
                      ld_sperr,
                      ld_dokunr,
                      ld_done,
                      ld_storno,
                      ld_stat,
                      ld_abk,
                      ld_an_nr
                  FROM _data
              $$ LANGUAGE sql STABLE PARALLEL SAFE;
          --
      --


    $f1$ -- EXECUTE end

    RETURN;

  END $f0$ LANGUAGE plpgsql;

  --- SELECT TSystem.views__wawipos__layouts__create();


           /*
                    DROP FUNCTION IF EXISTS TWawi.default_columns__wawi_pos__basics(auftg);
                    CREATE OR REPLACE FUNCTION TWawi.default_columns__wawi_pos__basics(IN _p TWawi.view__pos__type, IN _art art = null)
                      RETURNS TWawi.default_columns__wawi_pos__basics__type
                        AS $$
                            WITH  data AS (SELECT _p.*)
                            SELECT dbrid,
                                   p_id,
                                   p_code,
                                   p_dokunr,
                                   p_pos,
          
                                   p_adk_ad_krz,
                                   adressename(p_adk_ad_krz),
          
                                   p_aknr,
                                   coalesce(p_akbz, ak_bez)
                              FROM data
                        $$ LANGUAGE sql STABLE PARALLEL SAFE;
                    --
                    DROP FUNCTION IF EXISTS TWawi.default_columns__pos__art__mengen(TWawi.view__wawi_pos__mengen__typ);
                    CREATE OR REPLACE FUNCTION TWawi.default_columns__pos__art__mengen(IN _p TWawi.view__wawi_pos__mengen__typ)
                      RETURNS TWawi.view__wawi_pos__mengen__typ
                        AS $$
                            WITH  data AS (SELECT _p.*)
                            SELECT 
                                   ag_aknr,
                                   ag_aknr_idx,
                                   coalesce(ag_akbz, ak_bez) AS ak_bez,
          
                                   ag_stk,
                                            tartikel.me__menge_uf1__in__menge(ag_mcv, ag_stkl) AS ag_stkl_uf,
                                   ag_stk - tartikel.me__menge_uf1__in__menge(ag_mcv, ag_stkl) AS p_mengeo,
                                            tartikel.me__menge_uf1__in__menge(ag_mcv, ag_stkf) AS ag_stkf_uf,
          
                                   lang_artmgc_id_iso(p_me),
          
                                   p_IsBedarf
                              FROM data
                        $$ LANGUAGE sql STABLE PARALLEL SAFE;
          */
          --